/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.client.screen;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeRegistry;
import me.angel.challenges6t4.client.ActiveChallengesOverlay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class ChallengesScreen
extends class_437 {
    private final class_437 parent;
    private float scrollPosition = 0.0f;
    private boolean isDragging = false;
    private static final int ENTRY_HEIGHT = 32;
    private static final int CATEGORY_HEIGHT = 24;
    private static final int CATEGORY_SPACING = 10;
    private static final int CHALLENGE_SPACING = 6;
    private static final int HEADER_HEIGHT = 50;
    private static final int FOOTER_HEIGHT = 32;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int ENTRY_SPACING = 2;
    private final List<MenuEntry> menuEntries = new ArrayList<MenuEntry>();
    private final List<ButtonBounds> challengeButtonBounds = new ArrayList<ButtonBounds>();
    private ButtonBounds hoveredButton = null;
    private int hoveredMouseX = 0;
    private int hoveredMouseY = 0;

    public ChallengesScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"challenges6t4.screen.title"));
        this.parent = parent;
        this.initializeEntries();
    }

    private void initializeEntries() {
        this.menuEntries.clear();
        this.menuEntries.add(new MenuEntry("--= Block Color Challenges =--"));
        this.addChallengeIfRegistered("cant_touch_green");
        this.addChallengeIfRegistered("cant_touch_red");
        this.addChallengeIfRegistered("can_only_touch_green");
        this.menuEntries.add(new MenuEntry("--= Weather/Environmental Challenges =--"));
        this.addChallengeIfRegistered("cant_breathe_air");
        this.menuEntries.add(new MenuEntry("--= Special Mechanics Challenges =--"));
        this.addChallengeIfRegistered("exploding_mobs");
        this.addChallengeIfRegistered("disappearing_blocks");
        this.menuEntries.add(new MenuEntry("--= Teleportation/Movement Challenges =--"));
        this.addChallengeIfRegistered("ender_pearl_on_damage");
        this.addChallengeIfRegistered("super_knockback");
        this.addChallengeIfRegistered("chunk_swap");
        this.addChallengeIfRegistered("player_swap");
        this.menuEntries.add(new MenuEntry("--= Economy/Purchase Challenges =--"));
        this.menuEntries.add(new MenuEntry("--= Misc Challenges =--"));
    }

    private void addChallengeIfRegistered(String challengeId) {
        Challenge challenge = ChallengeRegistry.getChallenge(challengeId);
        if (challenge != null) {
            this.menuEntries.add(new MenuEntry(challenge));
        }
    }

    private int getTotalContentHeight() {
        int y = 0;
        for (MenuEntry entry : this.menuEntries) {
            if (entry.isCategory) {
                y += 34;
                continue;
            }
            y += 38;
        }
        return y;
    }

    private int getMaxScroll() {
        int contentHeight = this.getTotalContentHeight();
        int visibleHeight = this.field_22790 - 50 - 32;
        return Math.max(0, contentHeight - visibleHeight);
    }

    protected void method_25426() {
        this.method_37067();
        this.challengeButtonBounds.clear();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Disable All"), button -> {
            for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
                if (!challenge.isEnabled()) continue;
                challenge.setEnabled(false);
            }
            this.field_22787.method_1507((class_437)new ChallengesScreen(this.parent));
        }).method_46434(this.field_22789 - 100 - 8, 8, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Notifications: " + (ActiveChallengesOverlay.areNotificationsEnabled() ? "ON" : "OFF"))), button -> {
            ActiveChallengesOverlay.toggleNotifications();
            button.method_25355((class_2561)class_2561.method_43470((String)("Notifications: " + (ActiveChallengesOverlay.areNotificationsEnabled() ? "ON" : "OFF"))));
        }).method_46434(8, 8, 140, 20).method_46431());
        int y = 0;
        for (MenuEntry entry : this.menuEntries) {
            entry.virtualY = y;
            if (entry.isCategory) {
                y += 34;
                continue;
            }
            y += 38;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = this.getMaxScroll();
        this.scrollPosition = class_3532.method_15363((float)(this.scrollPosition - (float)(verticalAmount * 20.0)), (float)0.0f, (float)maxScroll);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.isDragging) {
            int maxScroll = this.getMaxScroll();
            int visibleHeight = this.field_22790 - 50 - 32;
            int contentHeight = this.getTotalContentHeight();
            float scrollAmount = (float)(deltaY * (double)maxScroll) / (float)(visibleHeight - Math.max(32, (int)((float)visibleHeight / (float)contentHeight * (float)visibleHeight)));
            this.scrollPosition = class_3532.method_15363((float)(this.scrollPosition + scrollAmount), (float)0.0f, (float)maxScroll);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int doneBtnW = 200;
            int doneBtnH = 20;
            int doneBtnX = this.field_22789 / 2 - doneBtnW / 2;
            int doneBtnY = this.field_22790 - 28;
            if (mouseX >= (double)doneBtnX && mouseX <= (double)(doneBtnX + doneBtnW) && mouseY >= (double)doneBtnY && mouseY <= (double)(doneBtnY + doneBtnH)) {
                this.method_25419();
                return true;
            }
            int scrollbarX = this.field_22789 - 6 - 4;
            int scrollbarY = 50;
            int scrollbarHeight = this.field_22790 - 50 - 32;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 6) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                this.isDragging = true;
                return true;
            }
            for (ButtonBounds bounds : this.challengeButtonBounds) {
                if (!bounds.isHovered((int)mouseX, (int)mouseY)) continue;
                bounds.challenge.setEnabled(!bounds.challenge.isEnabled());
                this.method_25426();
                return true;
            }
            int optionsW = 70;
            int optionsX = this.field_22789 - 90;
            for (MenuEntry entry : this.menuEntries) {
                if (entry.isCategory || entry.challenge == null || !entry.challenge.hasOptions()) continue;
                int y = entry.virtualY - (int)this.scrollPosition + 50;
                if (!(mouseX >= (double)optionsX) || !(mouseX <= (double)(optionsX + optionsW)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 32))) continue;
                this.openOptionsScreen(entry.challenge);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -1072689136);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Challenges Menu"), this.field_22789 / 2 - 50, 20, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
        int visibleTop = 50;
        int visibleBottom = this.field_22790 - 32;
        int visibleHeight = visibleBottom - visibleTop;
        int contentHeight = this.getTotalContentHeight();
        int maxScroll = this.getMaxScroll();
        this.scrollPosition = class_3532.method_15363((float)this.scrollPosition, (float)0.0f, (float)maxScroll);
        this.challengeButtonBounds.clear();
        int buttonX = 20;
        int buttonW = this.field_22789 - 120;
        int optionsW = 70;
        int optionsX = this.field_22789 - 90;
        for (MenuEntry entry : this.menuEntries) {
            int y = entry.virtualY - (int)this.scrollPosition + 50;
            if (y + (entry.isCategory ? 24 : 32) < visibleTop || y > visibleBottom) continue;
            if (entry.isCategory) {
                int catWidth = this.field_22793.method_1727(entry.categoryName);
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)entry.categoryName), (this.field_22789 - catWidth) / 2, y + 2, -22016);
                continue;
            }
            if (entry.challenge == null) continue;
            String label = entry.challenge.getName().getString() + " [" + (entry.challenge.isEnabled() ? "ON" : "OFF") + "]";
            int btnW = entry.challenge.hasOptions() ? this.field_22789 - 120 : this.field_22789 - 40;
            int btnX = 20;
            int btnY = y;
            context.method_25294(btnX, btnY, btnX + btnW, btnY + 32, -12303292);
            int labelWidth = this.field_22793.method_1727(label);
            int n = btnX + (btnW - labelWidth) / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_25303(this.field_22793, label, n, btnY + (32 - 9) / 2, -1);
            this.challengeButtonBounds.add(new ButtonBounds(btnX, btnY, btnW, 32, entry.challenge));
            if (!entry.challenge.hasOptions()) continue;
            context.method_25294(optionsX, btnY, optionsX + optionsW, btnY + 32, -10066330);
            int optLabelWidth = this.field_22793.method_1727("Options");
            int n2 = optionsX + (optionsW - optLabelWidth) / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_25303(this.field_22793, "Options", n2, btnY + (32 - 9) / 2, -1);
        }
        if (contentHeight > visibleHeight) {
            int scrollbarHeight = Math.max(32, (int)((float)visibleHeight / (float)contentHeight * (float)visibleHeight));
            int scrollbarY = 50 + (int)(this.scrollPosition / (float)maxScroll * (float)(visibleHeight - scrollbarHeight));
            int scrollbarX = this.field_22789 - 6 - 4;
            context.method_25294(scrollbarX, 50, scrollbarX + 6, this.field_22790 - 32, -14540254);
            context.method_25294(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, -5592406);
        }
        this.hoveredButton = null;
        for (ButtonBounds bounds : this.challengeButtonBounds) {
            if (!bounds.isHovered(mouseX, mouseY)) continue;
            this.hoveredButton = bounds;
            this.hoveredMouseX = mouseX;
            this.hoveredMouseY = mouseY;
            break;
        }
        if (this.hoveredButton != null) {
            List lines = this.field_22793.method_1728((class_5348)this.hoveredButton.challenge.getDescription(), 250);
            int tooltipX = this.hoveredMouseX + 12;
            int tooltipY = this.hoveredMouseY + 12;
            int tooltipWidth = 0;
            for (class_5481 line : lines) {
                int lineWidth = this.field_22793.method_30880(line);
                if (lineWidth <= tooltipWidth) continue;
                tooltipWidth = lineWidth;
            }
            int n = lines.size();
            Objects.requireNonNull(this.field_22793);
            int tooltipHeight = n * (9 + 2);
            context.method_25294(tooltipX - 4, tooltipY - 4, tooltipX + tooltipWidth + 8, tooltipY + tooltipHeight + 4, -267382768);
            context.method_25294(tooltipX - 5, tooltipY - 5, tooltipX + tooltipWidth + 9, tooltipY - 4, -5592406);
            context.method_25294(tooltipX - 5, tooltipY + tooltipHeight + 4, tooltipX + tooltipWidth + 9, tooltipY + tooltipHeight + 5, -5592406);
            context.method_25294(tooltipX - 5, tooltipY - 5, tooltipX - 4, tooltipY + tooltipHeight + 5, -5592406);
            context.method_25294(tooltipX + tooltipWidth + 8, tooltipY - 5, tooltipX + tooltipWidth + 9, tooltipY + tooltipHeight + 5, -5592406);
            int y = tooltipY;
            for (class_5481 line : lines) {
                context.method_35720(this.field_22793, line, tooltipX, y, -1);
                Objects.requireNonNull(this.field_22793);
                y += 9 + 2;
            }
        }
        int doneBtnW = 200;
        int doneBtnH = 20;
        int doneBtnX = this.field_22789 / 2 - doneBtnW / 2;
        int doneBtnY = this.field_22790 - 28;
        boolean hovered = mouseX >= doneBtnX && mouseX <= doneBtnX + doneBtnW && mouseY >= doneBtnY && mouseY <= doneBtnY + doneBtnH;
        int btnColor = hovered ? -7829368 : -10066330;
        context.method_25294(doneBtnX, doneBtnY, doneBtnX + doneBtnW, doneBtnY + doneBtnH, btnColor);
        int labelWidth = this.field_22793.method_1727("Done");
        int n = doneBtnX + (doneBtnW - labelWidth) / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_25303(this.field_22793, "Done", n, doneBtnY + (doneBtnH - 9) / 2, -1);
    }

    private void openOptionsScreen(Challenge challenge) {
        try {
            String challengeClassName = challenge.getClass().getSimpleName();
            String optionsScreenName = challengeClassName.endsWith("Challenge") ? challengeClassName.substring(0, challengeClassName.length() - "Challenge".length()) + "OptionsScreen" : challengeClassName + "OptionsScreen";
            String optionsScreenClassName = "me.angel.challenges6t4.client.screen." + optionsScreenName;
            Class<?> optionsScreenClass = Class.forName(optionsScreenClassName);
            Class<?> challengeClass = challenge.getClass();
            Constructor<?> constructor = optionsScreenClass.getConstructor(class_437.class, challengeClass);
            class_437 optionsScreen = (class_437)constructor.newInstance(new Object[]{this, challenge});
            if (optionsScreen != null) {
                this.field_22787.method_1507(optionsScreen);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to open options screen for challenge: " + challenge.getId());
            e.printStackTrace();
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    @Environment(value=EnvType.CLIENT)
    private static class ButtonBounds {
        int x;
        int y;
        int w;
        int h;
        Challenge challenge;

        ButtonBounds(int x, int y, int w, int h, Challenge challenge) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.challenge = challenge;
        }

        boolean isHovered(int mx, int my) {
            return mx >= this.x && mx < this.x + this.w && my >= this.y && my < this.y + this.h;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class MenuEntry {
        final Challenge challenge;
        final boolean isCategory;
        final String categoryName;
        int virtualY;
        class_4185 toggleButton;
        class_4185 optionsButton;
        int infoX;
        int infoY;

        MenuEntry(String categoryName) {
            this.categoryName = categoryName;
            this.isCategory = true;
            this.challenge = null;
        }

        MenuEntry(Challenge challenge) {
            this.challenge = challenge;
            this.isCategory = false;
            this.categoryName = null;
        }
    }
}

